unit fROR_LocalFields;
{
================================================================================
*
*       Package:        ROR - Clinical Case Registries
*       Date Created:   March 31, 2013
*       Site:           Hines OIFO
*       Developers:     Ed Micyus
*       Description:    Data entry window used to replace TMS advanced column
*                       grid for visually impaired users.
*
*       Notes:
*
================================================================================
}
interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TFormLocalFields = class(TForm)
    btnOK: TButton;
    btnCancel: TButton;
    cmbMode0: TComboBox;
    lblMode0: TLabel;
    lblDesc0: TLabel;
    edtDesc0: TEdit;
    stxtInstruct: TStaticText;
    lblName0: TLabel;
    edtName0: TEdit;
    procedure FormShow(Sender: TObject);
    procedure cmbModeChange(Sender: TObject);
  private
    { Private declarations }
    fListData: TStringList;
    fModes: TStringList;
    fDescs: TStringList;
    fNames: TStringList;
    fIENs:  TStringList;
  public
    { Public declarations }
    constructor Create(aList: TStringList; aOwner: TComponent = nil); reintroduce;
    destructor  Destroy; override;

    property ListData: TStringList          read fListData;

    function Edit: integer;
  end;

var
  FormLocalFields: TFormLocalFields;

implementation

uses uROR_Common, uROR_Utilities;

{$R *.dfm}

function getItemIndex(const aMode: String): integer;
begin
  Result := 1;
  if aMode = 'Include' then
    Result := 0
  else if aMode = 'Exclude' then
    Result := 2;
end;

constructor TFormLocalFields.Create(aList: TStringList; aOwner: TComponent);
var i: integer;
  lbl1, lbl2, lbl3: TLabel;
  edt1, edt2: TEdit;
  cmb1: TComboBox;
begin
  if Assigned(aOwner) then
    inherited Create(aOwner)
  else
    inherited Create(Application);

  fListData := aList;
  fModes := TStringList.Create;
  fDescs := TStringList.Create;
  fNames := TStringList.Create;
  fIENs  := TStringList.Create;
  for i := 0 to fListData.Count - 1 do
  begin
    fModes.Add(Piece(fListData[i], U, 1));
    fDescs.Add(Piece(fListData[i], U, 2));
    fNames.Add(Piece(fListData[i], U, 3));
    fIENs.Add(Piece(fListData[i], U, 4));
  end;

  //Load values for first local field
  edtName0.Text := fNames[0];
  edtDesc0.Text := fDescs[0];
  cmbMode0.ItemIndex := getItemIndex(fModes[0]);

  //Create controls for the remainder of the local fields
  for i := 1 to fListData.Count - 1 do
  begin
    lbl1 := TLabel.Create(self);
    lbl1.Name    := Format('lblName%d', [i]);
    lbl1.Caption := lblName0.Caption;
    lbl1.Left    := lblName0.Left;
    lbl1.Top     := lblName0.Top + (i * 25);
    lbl1.Parent  := self;

    edt1 := TEdit.Create(self);
    edt1.Name       := Format('edtName%d', [i]);
    edt1.Color      := edtName0.Color;
    edt1.Tag        := i;
    edt1.Text       := fNames[i];
    edt1.Left       := edtName0.Left;
    edt1.Top        := edtName0.Top + (i * 25);
    edt1.Width      := edtName0.Width;
    edt1.ReadOnly   := true;
    edt1.Parent     := self;

    lbl2 := TLabel.Create(self);
    lbl2.Name    := Format('lblDesc%d', [i]);
    lbl2.Caption := lblDesc0.Caption;
    lbl2.Left    := lblDesc0.Left;
    lbl2.Top     := lblDesc0.Top + (i * 25);
    lbl2.Parent  := self;

    edt2 := TEdit.Create(self);
    edt2.Name       := Format('edtDesc%d', [i]);
    edt2.Color      := edtDesc0.Color;
    edt2.Tag        := i;
    edt2.Text       := fDescs[i];
    edt2.Left       := edtDesc0.Left;
    edt2.Top        := edtDesc0.Top + (i * 25);
    edt2.Width      := edtDesc0.Width;
    edt2.ReadOnly   := true;
    edt2.Parent     := self;

    lbl3         := TLabel.Create(self);
    lbl3.Name    := Format('lblMode%d', [i]);
    lbl3.Caption := 'Mode';
    lbl3.Left    := lblMode0.Left;
    lbl3.Top     := lblMode0.Top + (i * 25);
    lbl3.Parent  := self;

    cmb1         := TComboBox.Create(self);
    cmb1.Name    := Format('cmbMode%d', [i]);
    cmb1.Tag     := i;
    cmb1.Parent  := self;
    cmb1.Left    := cmbMode0.Left;
    cmb1.Top     := cmbMode0.Top + (i * 25);
    cmb1.Width   := cmbMode0.Width;
    cmb1.Items.Add('Include');
    cmb1.Items.Add('Ignore');
    cmb1.Items.Add('Exclude');
    cmb1.ItemIndex := getItemIndex(fModes[i]);
    cmb1.SelLength := 0;
    cmb1.OnChange := cmbModeChange;

    self.Height := self.Height + 25;
  end;
end;

destructor TFormLocalFields.Destroy;
begin
  fListData := nil;
  inherited;
end;

procedure TFormLocalFields.FormShow(Sender: TObject);
begin
  stxtInstruct.SetFocus;
end;

function TFormLocalFields.Edit: Integer;
begin
  Result := ShowModal;
end;

procedure TFormLocalFields.cmbModeChange(Sender: TObject);
var iTag: integer;
begin
  iTag := (Sender as TComboBox).Tag;
  ListData[iTag] := (Sender as TComboBox).Items[(Sender as TComboBox).ItemIndex]
    + U + piece(ListData[iTag], U, 2, 5);
end;

end.
